:: Melissa Data Address Object Java Wrapper Create DLL Script
::
:: Instructions:
::
:: 1. Make sure the below paths are correctly set
::    Java paths should lead to the equivalent folders as shown below
::    AddrLibraryPath should lead to the Address Object dll (mdAddr.dll) matching your architecture (32bit or 64bit)
::
:: 2. Open a Visual Studio Command Prompt or manually execute Vcvarsall.bat (usually found in the
::    C:\Program Files\Microsoft Visual Studio 8\VC directory). 
::    *For 64 bit compilation, open the 64bit version of the Visual Studio command prompt or specify 
::    "amd64" argument after Vcvarsall.bat. 
::
:: 3. From the same command prompt "cd" to the folder that contains this script
::
:: 4. Type 'BuildWrapper' at the command line to execute this script.


@echo off

rem Set Java Includes and AddressObject Library Path 

set JavaIncludeDirectory1="C:\Program Files\Java\jdk1.6.0_01\include" 
Set JavaIncludeDirectory2="C:\Program Files\Java\jdk1.6.0_01\include\win32"
set AddrLibraryPath="C:\Program Files\Melissa DATA\DQT\AddrObj\dll_64bit"



cl -I%AddrLibraryPath% -I%JavaIncludeDirectory1% -I%JavaIncludeDirectory2% -FemdAddrJavaWrapper.dll mdAddrJavaWrapper.cpp -link -DLL -LIBPATH:%AddrLibraryPath% -DEFAULTLIB:mdAddr.lib

del mdAddrJavaWrapper.exp
del mdAddrJavaWrapper.obj
del mdAddrJavaWrapper.lib

pause